#ifndef __C4DBASEMATERIAL_H
#define __C4DBASEMATERIAL_H

#include "operatingsystem.h"
#include "c4d_baselist.h"

class BaseMaterial : public BaseList2D
{
	private:
		BaseMaterial(void);
	public:
		BaseMaterial *GetNext(void) { return (BaseMaterial*)AtCall(GetNext)(); }
		BaseMaterial *GetPred(void) { return (BaseMaterial*)AtCall(GetPred)(); }

		void Update(Bool preview, Bool rttm);

		BaseChannel	  *GetChannel(LONG id) { return C4DOS.Mt->GetChannel(this,id); }
		BaseBitmap		*GetPreview(LONG flags);

		Bool Compare(BaseMaterial *snd);

		static BaseMaterial *Alloc(LONG type);
		static void Free(BaseMaterial *&mat);
};

class PluginMaterial : public BaseMaterial
{
	public:
		static PluginMaterial *Alloc(LONG type);
		static void Free(PluginMaterial *&mat);
};

class Material : public BaseMaterial
{
	private:
		Material(void);
	public:
		Bool GetChannelState(LONG channel) { return C4DOS.Mt->GetChannelState(this,channel); }
		void SetChannelState(LONG channel, Bool state) { C4DOS.Mt->SetChannelState(this,channel,state); }

		static Material *Alloc();
		static void Free(Material *&mat);
};

#endif
